*! version 4.0
* 29 June 2021
* NIDS-CRAM
* This do-file contains the code to create deflators to deflate NIDS-CRAM Wave 2 financial data. Deflated values can be generated by multiplying the relevant 
* financial data variable by the deflator generated by this do-file.

*=====================================================================================================================================
/*

THIS DO FILE CREATES DEFLATORS FOR USE WITH THE NIDS-CRAM DATASET.
BASE MONTH IS FEB 2020 AND INTERVIEW DATES ARE TAKEN FROM THE HOUSEHOLD QUESTIONNAIRE. MISSING INTERVIEW MONTHS ARE IMPUTED TO THE MODAL MONTH FOR THE RELEVANT WAVE.

PRICE INDICES ARE FROM THE NATIONAL HEADLINE CPI INDEX PUBLISHED BY STATS SA, AVAILABLE HERE:
http://www.statssa.gov.za/publications/P0141/CPIHistory.pdf??

http://www.statssa.gov.za/publications/P0141/P0141July2020.pdf

*/
*=====================================================================================================================================

* GLOBALS FOR DATA FILES AND VERSION SUFFIXES
global NC2Data "C:\Users\\Dropbox\Data\NIDS\Data\c1"				//File path to where input data is located. Change this path according to where your data folder is located on your computer.
global NC2VerIN "Wave2_Anon_V3.0.0"

global DataOUT "C:\Users\\Dropbox\Data\NIDS\Data\c1_d"			//File path to where you want to save subsequent data files. 
global VersionOUT "merged"

global temp "C:\Users\Desktop"									//Tempfile to hold all the working datasets, all working datasets will be deleted from this folder at the completion of the do file execution.
																		
version 16.0													//Version of Stata being used.

clear
cap clear matrix
set more off

scalar base=115.2 												//Set scalar to base month, currently Feb 2020

*=====================================================================================================================================


* NIDS-CRAM QUESTIONNAIRE
use "$NC2Data\NIDS-CRAM_$NC2VerIN.dta", clear

cap drop w2_nc_deflator
gen w2_nc_deflator=.
replace w2_nc_deflator=base/116.4       // July 2020

lab var w2_nc_deflator "NIDS-CRAM W2 deflator"

save "$NC2Data\NIDS-CRAM_$VersionOUT.dta", replace

*=====================================================================================================================================

* end of do file


